/*
 * Simple test harness to check workings for calculating safe nude sunbathing
 * areas in the garden.
 * 
 * nib 2007-04-24
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define sgn(x) ((int)(((x) < 0) ? -1 : ((x) > 0)? 1 : 0))

/*
 * Most model data are global. All XY co-ordinates in this model are in units
 * of the array index (which happen to represent 0.5m at the moment). Where
 * necessary we imagine the centre points of the cells to be at 0.5-cell
 * values and the boundaries at whole integers. Index [0][0] is the NE
 * corner of the patio, [26][0] is the SE corner by the willow. The Z coord
 * is read in as metres but is converted to 0.5m units.
 */
struct
{
	double z;
	int clear;
}
garden[22][26];

void bomb(long n, char *mess)
{
	fprintf(stderr, "%ld, %s\n", mess);
}

void load_simple_data(void)
{
	FILE *fip;
	long i, j;
	char s[100];

	fip = fopen("simple_data.txt", "r");
	if (fip == NULL) bomb (1, "can't open garden data");

	for (i=0; i<26; i++)
		for (j=0; j<22; j++)
		{
			if (NULL == fgets(s, 100, fip))
				bomb(2, "error in reading garden data");
			garden[j][25-i].z = 2.0 * atof(s);
			garden[j][25-i].clear = 0;
		}
}

void test_print_garden(void)
{
	long i, j;

	for (i=0; i<26; i++)
	{
		for (j=0; j<22; j++)
		{
			printf("%lf ", garden[j][i].z);
		}
		printf("\n");
	}
}

void print_result(void)
{
	long i, j;
	char c;

	for (i=0; i<26; i++)
	{
		for (j=0; j<22; j++)
		{
			switch (garden[j][25-i].clear)
			{
			case -1:	/* fence */
				c = '*';
				break;
			case 0:		/* overlooked */
				c = ' ';
				break;
			case 1:		/* screened */
				c = ':';
				break;
			default:
				c = '#';
				break;
			}
			printf("%c ", c);
		}
		printf("\n");
	}
}

/*
 * Test routine goes round each cell, adds the required clear height,
 * draws a line from here to a specified observer point, goes along the
 * line working out which other cells it crosses, if the height of any
 * other cell is greater than the line height, makes the initial cell
 * not clear and gets on with the next initial cell.
 */
void update(double xe, double ye, double ze)
{
	long x, y;
	double xc, yc, zc;
	int xdir, ydir;

	for (x=0; x<26; x++) for (y=0; y<22; y++)
	{
		/* mark the fences, anything over 0.2m */
		if (garden[y][x].z >= 0.4 )
		{
			garden[y][x].clear = -1;
			continue;
		}

		/* required height, above centre of cell */
		xc = x + 0.5;
		yc = y + 0.5;
		zc = garden[y][x].z + 1; /* 0.5m up for sunbathing */

		/* so the line is xc,yc,zc to xe,ye,ze */
		xdir = sgn(xe - xc);
		ydir = sgn(ye - yc);
		/* we only go in these directions, until we hit something
		 * for +ve xdir we look at x values from xc+0.5 to 25
		 * for -ve xdir we look at x values from xc-0.5 to 0
		 * for +ve ydir we look at y values from yc+0.5 to 21
		 * for -ve ydir we look at y values from yc-0.5 to 0
		 * in each case take floor() of the xy and this is the
		 * address of a cell that we cross.
		 */

		/* scan in x */
		/* scan in y */
	}
}

int main(int argc, char **argv)
{
	load_simple_data();
	update(15,50,4);
	print_result();
}
